// PlikSkrotuDlg.cpp : implementation file
//

#include "stdafx.h"
#include "PlikSkrotu.h"
#include "PlikSkrotuDlg.h"
#include <shlwapi.h> // PathRemoveFileSpec


#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CPlikSkrotuDlg dialog




CPlikSkrotuDlg::CPlikSkrotuDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPlikSkrotuDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CPlikSkrotuDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CPlikSkrotuDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BUTTON1, &CPlikSkrotuDlg::OnBnClickedButton1)
	ON_BN_CLICKED(IDC_BUTTON2, &CPlikSkrotuDlg::OnBnClickedButton2)
	ON_BN_CLICKED(IDC_BUTTON3, &CPlikSkrotuDlg::OnBnClickedButton3)
END_MESSAGE_MAP()


// CPlikSkrotuDlg message handlers

BOOL CPlikSkrotuDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CPlikSkrotuDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CPlikSkrotuDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

CString CPlikSkrotuDlg::Katalog_Pulpit()
{
	TCHAR path[MAX_PATH];
    SHGetSpecialFolderPath(NULL, path, CSIDL_DESKTOPDIRECTORY, FALSE);
    return CString(path);
}

void CPlikSkrotuDlg::TworzSkrotNaPulpicie(LPCTSTR sciezkaLinku, CParametrySkrotu parametrySkrotu)
{
	CString temp;
	temp.Format(L"%s\\%s", Katalog_Pulpit(), sciezkaLinku);
	TworzSkrot(temp, parametrySkrotu);
}

void CPlikSkrotuDlg::OnBnClickedButton1()
{
	CParametrySkrotu parametrySkrotu;
	GetModuleFileName(GetModuleHandle(NULL), parametrySkrotu.sciezkaPliku, MAX_PATH);
	wcscpy_s(parametrySkrotu.katalogRoboczy,MAX_PATH,parametrySkrotu.sciezkaPliku);
	PathRemoveFileSpec(parametrySkrotu.katalogRoboczy);
	wcscpy_s(parametrySkrotu.argumenty,260,L"");
	wcscpy_s(parametrySkrotu.opis,260,AfxGetApp()->m_pszAppName);
	parametrySkrotu.rodzajOkna = SW_SHOWNORMAL;
	wcscpy_s(parametrySkrotu.sciezkaIkony,MAX_PATH,parametrySkrotu.sciezkaPliku);
    parametrySkrotu.numerIkony = 0;
    parametrySkrotu.klawiszSkrotu = 'y';

	TworzSkrot(L"Skrot.lnk", parametrySkrotu);
}

void CPlikSkrotuDlg::OnBnClickedButton2()
{
	CParametrySkrotu parametrySkrotu;
	if (CzytajSkrot(L"Skrot.lnk", parametrySkrotu))
	{	
		CString temp;
		temp.Format(L"Informacje o pliku skrtu\nSciezka pliku: %s\nArgumenty: %s,\nKatalog roboczy: %s\nOpis: %s\nIkona: %s (nr ikony: %d)\nKlawisz skrtu: %c", 
			parametrySkrotu.sciezkaPliku,
			parametrySkrotu.argumenty,
			parametrySkrotu.katalogRoboczy,
			parametrySkrotu.opis,
			parametrySkrotu.sciezkaIkony,
			parametrySkrotu.numerIkony,
			parametrySkrotu.klawiszSkrotu);
		AfxMessageBox(temp);
	}
}

void CPlikSkrotuDlg::OnBnClickedButton3()
{
	CParametrySkrotu parametrySkrotu;
	GetModuleFileName(GetModuleHandle(NULL), parametrySkrotu.sciezkaPliku, MAX_PATH);
	wcscpy_s(parametrySkrotu.katalogRoboczy, parametrySkrotu.sciezkaPliku);
	PathRemoveFileSpec(parametrySkrotu.katalogRoboczy);
	//parametrySkrotu.opis = AfxGetApp()->m_pszAppName;
    parametrySkrotu.rodzajOkna = SW_SHOWNORMAL;
	wcscpy_s(parametrySkrotu.sciezkaIkony, parametrySkrotu.sciezkaPliku);
    parametrySkrotu.numerIkony = 0;
    parametrySkrotu.klawiszSkrotu = 'y';

	TworzSkrotNaPulpicie(L"Skrot.lnk", parametrySkrotu);
}
